import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Initialize the figure and axis
fig, ax = plt.subplots(figsize=(12, 10))

# Define colors
ingredient1_color = 'red'
ingredient2_color = 'blue'
empty_clean_color = 'white'

# Draw dispensers
dispenser1 = patches.Rectangle((2, 9), 2, 1, linewidth=1, edgecolor='black', facecolor=ingredient1_color)
dispenser2 = patches.Rectangle((8, 9), 2, 1, linewidth=1, edgecolor='black', facecolor=ingredient2_color)
ax.add_patch(dispenser1)
ax.add_patch(dispenser2)
ax.text(3, 9.5, 'dispenser1', ha='center', va='center', fontsize=10, color='white')
ax.text(9, 9.5, 'dispenser2', ha='center', va='center', fontsize=10, color='white')

# Draw shots
shot1 = patches.Rectangle((1, 6), 1.5, 1, linewidth=1, edgecolor='black', facecolor=empty_clean_color)
shot2 = patches.Rectangle((5, 6), 1.5, 1, linewidth=1, edgecolor='black', facecolor=empty_clean_color)
shot3 = patches.Rectangle((9, 6), 1.5, 1, linewidth=1, edgecolor='black', facecolor=empty_clean_color)
ax.add_patch(shot1)
ax.add_patch(shot2)
ax.add_patch(shot3)
ax.text(1.75, 6.5, 'shot1\nClean\nEmpty', ha='center', va='center', fontsize=9)
ax.text(5.75, 6.5, 'shot2\nClean\nEmpty', ha='center', va='center', fontsize=9)
ax.text(9.75, 6.5, 'shot3\nClean\nEmpty', ha='center', va='center', fontsize=9)

# Draw shaker
shaker1 = patches.Circle((5.5, 3), 1.5, linewidth=1, edgecolor='black', facecolor=empty_clean_color)
ax.add_patch(shaker1)
ax.text(5.5, 3, 'shaker1\nClean\nEmpty\nLevel l0', ha='center', va='center', fontsize=9)

# Draw hands
left_hand = patches.Rectangle((3, 1), 1.5, 0.75, linewidth=1, edgecolor='black', facecolor=empty_clean_color)
right_hand = patches.Rectangle((8, 1), 1.5, 0.75, linewidth=1, edgecolor='black', facecolor=empty_clean_color)
ax.add_patch(left_hand)
ax.add_patch(right_hand)
ax.text(3.75, 1.375, 'left\nhand\nEmpty', ha='center', va='center', fontsize=9)
ax.text(8.75, 1.375, 'right\nhand\nEmpty', ha='center', va='center', fontsize=9)

# Set limits and remove axes
ax.set_xlim(0, 12)
ax.set_ylim(0, 11)
ax.axis('off')

# Legend
legend_elements = [
    patches.Patch(facecolor=ingredient1_color, edgecolor='black', label='Ingredient1 (Red)'),
    patches.Patch(facecolor=ingredient2_color, edgecolor='black', label='Ingredient2 (Blue)')
]
ax.legend(handles=legend_elements, loc='upper left', fontsize=9)

# Save the figure
plt.savefig('barman/one_shot/ini_diagram_code/attempts/attempt_13.png', bbox_inches='tight')
plt.show()